"""stock_management_system URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path
from . import views

urlpatterns = [
    path('', views.index, name='index'),
    path('add_jerseys/', views.add_jerseys, name='add_jerseys'),
    path('add_ties/', views.add_ties, name='add_ties'),
    path('update_product/', views.update_product, name='update_product'),
    path('restock_products_list/', views.restock_products_list, name='restock_products_list'),
    path('single_product_update/<int:pk>', views.single_product_update, name='single_product_update'),
    path('single_product_restock/<int:pk>', views.single_product_restock, name='single_product_restock'),
    path('issue_products/', views.issue_products, name='issue_products'),
    path('print_receipt', views.print_receipt, name='print_receipt'),
    path('api/sizes/', views.get_sizes, name='get_sizes'), 
    path('submit_category_and_size/', views.submit_category_and_size, name='your_ajax_url'),
    path('printb/', views.printb, name='printb'),
    path('search_reciept', views.search_reciept, name='search_reciept'),
    path('search_stocks', views.search_stocks, name='search_stocks'),
    path('login/', views.user_login, name='login'),
    path('logout/', views.user_logout, name='logout'),
    
]
