from typing import Any, Mapping
from django import forms
from django.forms import ModelForm
from django.forms.renderers import BaseRenderer
from django.forms.utils import ErrorList
from .models import Category, Size, Product, Issued_Item

# Create your models here.
   
class CategoryForm(forms.ModelForm):
    category = forms.ChoiceField(
        required=False,
        choices=Category.CATE_CHOICE,
        widget=forms.Select(attrs={"class": "form-control"})
    )

    class Meta:
        model = Category
        fields = '__all__'



class JerseyForm(forms.ModelForm):
    category = forms.ModelChoiceField(
        queryset=Category.objects.all(),
        widget=forms.Select(attrs={"class": "form-control"}),
        label='Category'
    )
    size = forms.ModelChoiceField(
        queryset=Size.objects.none(),
        widget=forms.Select(attrs={"class": "form-control"}),
        label='Size'
    )
    color = forms.CharField(
        widget=forms.TextInput(attrs={"class": "form-control"}),
        label='Color'
    )
    quantity = forms.IntegerField(
        widget=forms.NumberInput(attrs={"class": "form-control", "id":"existing_qty"}),
        label='Quantity'
    )
    price = forms.DecimalField(
        widget=forms.NumberInput(attrs={"class": "form-control"}),
        label='Price'
    )

    def __init__(self, *args, **kwargs):
        super(JerseyForm, self).__init__(*args, **kwargs)
        self.fields['category'].initial = Category.objects.first()
        
        
        if 'category' in self.data:

            try:
                category_id = int(self.data.get('category'))
                self.fields['size'].queryset = Size.objects.filter(category_id=category_id).order_by('name')
            except (ValueError, TypeError):
                self.fields['size'].queryset = Size.objects.none()
        elif self.instance.pk:
            self.fields['size'].queryset = self.instance.category.size_set.order_by('name')
        else:
            self.fields['size'].queryset = Size.objects.none()
            

    class Meta:
        model = Product
        fields = ['category', 'size', 'color', 'quantity', 'price']



class IssueItemForm(forms.ModelForm):
    category = forms.ModelChoiceField(
        queryset=Category.objects.all(),
        widget=forms.Select(attrs={"class": "form-control"}),
        label='Category'
    )
    size = forms.ModelChoiceField(
        queryset=Size.objects.none(),
        widget=forms.Select(attrs={"class": "form-control"}),
        label="Size"
    )
    studentName = forms.CharField(
        widget=forms.TextInput(attrs={"class": "form-control"}),
        label="Student Name"
    )
    admissionNumber = forms.IntegerField(
        widget=forms.NumberInput(attrs={"class": "form-control"}),
        label="Admission Number"
    )
    quantity = forms.IntegerField(
        widget=forms.NumberInput(attrs={"class": "form-control"}),
        label="Quantity"
    )
    price = forms.DecimalField(
        widget=forms.NumberInput(attrs={"class": "form-control"}),
        label="Price"
    )

    def __init__(self, *args, **kwargs):
        super(IssueItemForm, self).__init__(*args, **kwargs)
        # self.fields['category'].initial = Category.objects.first()

        if 'category' in self.data:
            try:
                category_id = int(self.data.get('category'))
                self.fields['size'].queryset = Size.objects.filter(category_id=category_id).order_by('name')
            except (ValueError, TypeError):
                self.fields['size'].queryset = Size.objects.none()
        elif self.instance.pk:
            self.fields['size'].queryset = self.instance.category.size_set.order_by('name')
        else:
            self.fields['size'].queryset = Size.objects.none()

    class Meta:
        model = Issued_Item
        fields = ['category', 'size', 'admissionNumber', 'studentName', 'quantity', 'price']


class ReceiptSearchForm(forms.Form):
    student_name = forms.CharField(
        max_length=100,
        required=False,
        widget=forms.TextInput(attrs={'class': 'form-control'})
    )
    admission_number = forms.IntegerField(
        required=False,
        widget=forms.NumberInput(attrs={'class': 'form-control'})
    )
    bill_number = forms.IntegerField(
        required=False,
        widget=forms.NumberInput(attrs={'class': 'form-control'})
    )
    date_from = forms.DateField(
        required=False,
        widget=forms.DateInput(attrs={'type': 'date', 'class': 'form-control'})
    )
    date_to = forms.DateField(
        required=False,
        widget=forms.DateInput(attrs={'type': 'date', 'class': 'form-control'})
    )
    category = forms.ModelChoiceField(
        queryset=Category.objects.all(),
        required=False,
        widget=forms.Select(attrs={'class': 'form-control'})
    )
    size = forms.ModelChoiceField(
        queryset=Size.objects.all(),
        required=False,
        widget=forms.Select(attrs={'class': 'form-control'})
    )

class searchStock (forms.Form):
    category = forms.ModelChoiceField(
        queryset=Category.objects.all(),
        required=False,
        widget=forms.Select(attrs={'class': 'form-control'})
    )
    size = forms.ModelChoiceField(
        queryset=Size.objects.all(),
        required=False,
        widget=forms.Select(attrs={'class': 'form-control'})
    )





