from django.db import models

# Create your models here.


# this is the main categories.  if you need to add a new category need to change here
class Category(models.Model):
    CATE_CHOICE = [
        ("JerseyGirls", "Jersey-Girls"),
        ("JerseyBoys", "Jersey-Boys"),
        ("ArmCutBoys", "Arm Cut-Boys" ),
        ("Tie", "Tie"),
        ("IceCap", "Ice Cap"),
        ("Bags", "Bags"),
        ("ECAKits", "ECA Kits")
    ]
    name = models.CharField(max_length=50, choices=CATE_CHOICE)
    def __str__(self):
        return self.get_name_display() 


class Size(models.Model):
    SIZE_CHOICE = [
        ('40', '40'),
        ('38', '38'),
        ('36', '36'),
        ('34', '34'),
        ('32', '32'),
        ('30', '30'),
        ('28', '28'),
        ('26', '26'),
        ('S', 'Small'),
        ('M', 'Medium'),
        ('L', 'Large'),
        ('A/L', 'A/L'),
        ('2XL', '2XL'),
        ('3XL', '3XL'),

    ]
    name = models.CharField(max_length=100, choices=SIZE_CHOICE)
    category = models.ForeignKey(Category, on_delete=models.CASCADE)

    def __str__(self):
        return f"{self.name}"    

class Product(models.Model):
    category = models.ForeignKey(Category, on_delete=models.CASCADE)
    size = models.ForeignKey(Size, on_delete=models.CASCADE)
    color = models.CharField(max_length=50)
    quantity = models.PositiveIntegerField(default=0, null=False)
    price = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)

    def __str__(self):
       return f"{self.category.get_name_display()} - {self.size.get_name_display()} - {self.color}"
    

class Issued_Item(models.Model):
    category = models.ForeignKey(Category, on_delete=models.CASCADE)
    size = models.ForeignKey(Size, on_delete=models.CASCADE)                       
    student_name = models.CharField(max_length=100)
    admission_number = models.IntegerField()
    quantity = models.PositiveIntegerField(default=0)
    price = models.DecimalField(max_digits=10, decimal_places=2, default=0.00)
    date_time = models.DateTimeField ()
    bill_number = models.IntegerField(default=0)

    def __str__(self):
        return f'Bill Number{self.bill_number} Number of {self.quantity} {self.size} issued to {self.admission_number} on {self.date_time}'

